#!/usr/bin/env  python
__license__   = 'GPL v3'

__copyright__ = '2008, Kovid Goyal kovid@kovidgoyal.net'
__docformat__ = 'restructuredtext en'

'''
globeandmail.com
'''

from calibre.web.feeds.news import BasicNewsRecipe

class GlobeAndMail(BasicNewsRecipe):
    title = u'Globe and Mail'
    language = 'en_CA'

    __author__ = 'Kovid Goyal'
    oldest_article = 7
    max_articles_per_feed = 100
    no_stylesheets = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''
	                  
    description = 'Canada\'s national newspaper'
    keep_only_tags = [dict(name='article')]
    remove_tags = [dict(name='aside'),
                   dict(name='footer'),
                   dict(name='div', attrs={'id':['articlemeta','tgamvideoplayer1','blurb .sans','more-videos']}),
                   dict(name='div', attrs={'class':['twitterWidgetModule','gam-pagination articlepagination']}),
                   dict(name='div', attrs={'class':(lambda x: isinstance(x, (str,unicode)) and 'articlecommentcountholder' in x.split(' '))}),
                   dict(name='ul', attrs={'class':(lambda x: isinstance(x, (str,unicode)) and 'articletoolbar' in x.split(' '))}),
                   dict(name='img')
                  ]
    feeds = [
            (u'Latest headlines', u'http://www.theglobeandmail.com/?service=rss'),
            (u'Top stories', u'http://www.theglobeandmail.com/?service=rss&feed=topstories'),
            (u'National', u'http://www.theglobeandmail.com/news/national/?service=rss'),
            (u'World', u'http://www.theglobeandmail.com/news/world/?service=rss'),
            (u'Columnists', u'http://www.theglobeandmail.com/news/opinions/columnists/?service=rss'),
            (u'Sports', u'http://www.theglobeandmail.com/sports/?service=rss'),
            (u'Technology', u'http://www.theglobeandmail.com/news/technology/?service=rss'),
            (u'Arts', u'http://www.theglobeandmail.com/news/arts/?service=rss'),
            (u'Life', u'http://www.theglobeandmail.com/life/?service=rss'),
            (u'Blogs', u'http://www.theglobeandmail.com/blogs/?service=rss'),
            ]

    def get_article_url(self, article):
        url = BasicNewsRecipe.get_article_url(self, article)
        if '/video/' not in url:
            return url


    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		